/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQC;
import com.ibm.mq.MQCcsidTable;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQSESSION;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class MQMD {
    private static final String sccsid = "@(#) common/javabase/com/ibm/mq/MQMD.java, java, j521, j521-L020126  02/01/25 15:50:10";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 5694-137 (c) Copyright IBM Corp. 1997, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public int report = 0;
    public int messageType = 8;
    public int expiry = -1;
    public int feedback = 0;
    public int encoding = 273;
    public int characterSet = 0;
    public String format = "        ";
    public int priority = -1;
    public int persistence = 2;
    public byte[] messageId = new byte[24];
    public byte[] correlationId = new byte[24];
    public int backoutCount = 0;
    public String replyToQueueName = "";
    public String replyToQueueManagerName = "";
    public String userId = "";
    public byte[] accountingToken = new byte[32];
    public String applicationIdData = "";
    public int putApplicationType = 0;
    public String putApplicationName = "";
    public GregorianCalendar putDateTime = null;
    public String applicationOriginData = "";
    public byte[] groupId = new byte[24];
    public int messageSequenceNumber = 1;
    public int offset = 0;
    public int messageFlags = 0;
    public int originalLength = -1;
    String putDate = "";
    String putTime = "";
    private int version = 2;
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static GregorianCalendar putCalendar = null;
    protected static final int sizeofMQMDv1 = 324;
    protected static final int sizeofMQMDv2 = 364;
    private String cachedCcsidStr = null;
    private int cachedCcsid;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) throws MQException {
        if (Trace.isOn()) {
            Trace.entry(this, "setVersion");
            Trace.trace(2, this, "version = " + n);
        }
        if (n > 2 || n < 1) {
            Trace.exit(this, "setVersion (via exception)");
            throw new MQException(2, 2026, this, 13, "" + n);
        }
        this.version = n;
        if (n == 1) {
            boolean bl = false;
            if (this.groupId != null) {
                int n2 = 0;
                while (n2 < this.groupId.length) {
                    if (this.groupId[n2] != 0) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (bl || this.messageSequenceNumber != 1 || this.offset != 0 || this.messageFlags != 0 || this.originalLength != -1) {
                Trace.exit(this, "setVersion (via exception)");
                throw new MQException(2, 2026, this, 97);
            }
        }
        Trace.exit(this, "setVersion");
    }

    public MQMD() {
        Trace.entry(this, "MQMD constructor");
        Trace.trace(2, this, sccsid);
        Trace.exit(this, "MQMD constructor");
    }

    public final DataOutputStream writeTo(DataOutputStream dataOutputStream, int n, boolean bl) throws IOException, MQException {
        String string;
        Trace.entry(this, "writeTo");
        dataOutputStream.writeBytes("MD  ");
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeInt(this.report);
        dataOutputStream.writeInt(this.messageType);
        dataOutputStream.writeInt(this.expiry);
        dataOutputStream.writeInt(this.feedback);
        dataOutputStream.writeInt(this.encoding);
        dataOutputStream.writeInt(this.characterSet);
        String string2 = null;
        try {
            string2 = MQSESSION.setStringToLength(this.format, 8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataOutputStream.write(this.makeBytesFromString(string2, n, bl, false));
        dataOutputStream.writeInt(this.priority);
        dataOutputStream.writeInt(this.persistence);
        this.messageId = this.setArrayToLength(this.messageId, 24);
        dataOutputStream.write(this.messageId, 0, 24);
        this.correlationId = this.setArrayToLength(this.correlationId, 24);
        dataOutputStream.write(this.correlationId, 0, 24);
        dataOutputStream.writeInt(this.backoutCount);
        String string3 = null;
        try {
            string3 = MQSESSION.setStringToLength(this.replyToQueueName, 48);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataOutputStream.write(this.makeBytesFromString(string3, n, bl, true));
        String string4 = null;
        try {
            string4 = MQSESSION.setStringToLength(this.replyToQueueManagerName, 48);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataOutputStream.write(this.makeBytesFromString(string4, n, bl, true));
        String string5 = null;
        try {
            string5 = MQSESSION.setStringToLength(this.userId, 12);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataOutputStream.write(this.makeBytesFromString(string5, n, bl, false));
        try {
            this.accountingToken = this.setArrayToLength(this.accountingToken, 32);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataOutputStream.write(this.accountingToken, 0, 32);
        String string6 = null;
        try {
            string6 = MQSESSION.setStringToLength(this.applicationIdData, 32);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataOutputStream.write(this.makeBytesFromString(string6, n, bl, false));
        dataOutputStream.writeInt(this.putApplicationType);
        String string7 = null;
        try {
            string7 = MQSESSION.setStringToLength(this.putApplicationName, 28);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataOutputStream.write(this.makeBytesFromString(string7, n, bl, false));
        if (this.putDateTime == null) {
            string = MQMD.getDate(null);
            String string8 = MQMD.getTime(null);
            dataOutputStream.writeBytes(this.makeStringFromBytes(string.getBytes(), n, bl, true));
            dataOutputStream.writeBytes(this.makeStringFromBytes(string8.getBytes(), n, bl, true));
        } else {
            if (putCalendar == null) {
                putCalendar = new GregorianCalendar(GMT);
            }
            putCalendar.setTime(this.putDateTime.getTime());
            string = MQMD.getDate(putCalendar);
            dataOutputStream.writeBytes(this.makeStringFromBytes(string.getBytes(), n, bl, true));
            String string9 = MQMD.getTime(putCalendar);
            dataOutputStream.writeBytes(this.makeStringFromBytes(string9.getBytes(), n, bl, true));
        }
        string = null;
        try {
            string = MQSESSION.setStringToLength(this.applicationOriginData, 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataOutputStream.write(this.makeBytesFromString(string, n, bl, false));
        if (this.version > 1) {
            this.groupId = this.setArrayToLength(this.groupId, 24);
            dataOutputStream.write(this.groupId);
            dataOutputStream.writeInt(this.messageSequenceNumber);
            dataOutputStream.writeInt(this.offset);
            dataOutputStream.writeInt(this.messageFlags);
            dataOutputStream.writeInt(this.originalLength);
        }
        Trace.exit(this, "writeTo");
        return dataOutputStream;
    }

    private byte[] makeBytesFromString(String string, int n, boolean bl, boolean bl2) throws MQException {
        int n2;
        byte[] byArray = null;
        boolean bl3 = false;
        if (bl2) {
            bl3 = true;
        } else if (bl) {
            bl3 = true;
            n2 = 0;
            while (n2 < string.length() && bl3) {
                bl3 = string.charAt(n2) < '\u0080';
                ++n2;
            }
        }
        if (bl && bl3) {
            byArray = new byte[string.length()];
            n2 = 0;
            while (n2 < byArray.length) {
                byArray[n2] = (byte)string.charAt(n2);
                ++n2;
            }
        } else {
            if (this.cachedCcsidStr == null || this.cachedCcsid != n) {
                String string2 = String.valueOf(n);
                this.cachedCcsidStr = MQCcsidTable.lookup(string2);
                if (this.cachedCcsidStr == null) {
                    this.cachedCcsidStr = string2;
                }
                this.cachedCcsid = n;
            }
            try {
                byArray = string.getBytes(this.cachedCcsidStr);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.cachedCcsidStr = null;
                throw new MQInternalException(2, 2195, 87, this.cachedCcsidStr);
            }
        }
        return byArray;
    }

    private String makeStringFromBytes(byte[] byArray, int n, boolean bl, boolean bl2) throws MQException {
        String string = null;
        boolean bl3 = false;
        if (bl2) {
            bl3 = true;
        } else if (bl) {
            bl3 = true;
            int n2 = 0;
            while (n2 < byArray.length && bl3) {
                bl3 = byArray[n2] >= 0;
                ++n2;
            }
        }
        if (bl3 && bl) {
            char[] cArray = new char[byArray.length];
            int n3 = 0;
            while (n3 < byArray.length) {
                cArray[n3] = (char)byArray[n3];
                ++n3;
            }
            string = new String(cArray);
        } else {
            if (this.cachedCcsid != n || this.cachedCcsidStr == null) {
                String string2 = String.valueOf(n);
                this.cachedCcsidStr = MQCcsidTable.lookup(string2);
                if (this.cachedCcsidStr == null) {
                    this.cachedCcsidStr = string2;
                }
                this.cachedCcsid = n;
            }
            try {
                string = new String(byArray, this.cachedCcsidStr);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.cachedCcsidStr = null;
                throw new MQInternalException(2, 2195, 87, this.cachedCcsidStr);
            }
        }
        return string;
    }

    public final DataInputStream readFrom(DataInputStream dataInputStream, int n, boolean bl) throws IOException, MQException {
        Trace.entry(this, "readFrom");
        if (dataInputStream.available() < 324) {
            Trace.exit(this, "readFrom (via exception)");
            throw new MQInternalException(2, 2195, 84);
        }
        byte[] byArray = new byte[4];
        dataInputStream.read(byArray, 0, 4);
        String string = MQEnvironment.stringFromBytes(byArray);
        if (!string.equals("MD  ")) {
            Trace.exit(this, "readFrom (via exception)");
            throw new MQInternalException(2, 2195, 83, string);
        }
        this.version = dataInputStream.readInt();
        this.report = dataInputStream.readInt();
        this.messageType = dataInputStream.readInt();
        this.expiry = dataInputStream.readInt();
        this.feedback = dataInputStream.readInt();
        this.encoding = dataInputStream.readInt();
        this.characterSet = dataInputStream.readInt();
        byte[] byArray2 = new byte[8];
        dataInputStream.read(byArray2, 0, 8);
        this.format = this.makeStringFromBytes(byArray2, n, bl, false);
        this.priority = dataInputStream.readInt();
        this.persistence = dataInputStream.readInt();
        this.messageId = this.setArrayToLength(this.messageId, 24);
        dataInputStream.read(this.messageId, 0, 24);
        this.correlationId = this.setArrayToLength(this.correlationId, 24);
        dataInputStream.read(this.correlationId, 0, 24);
        this.backoutCount = dataInputStream.readInt();
        byte[] byArray3 = new byte[48];
        dataInputStream.read(byArray3, 0, 48);
        this.replyToQueueName = this.makeStringFromBytes(byArray3, n, bl, true);
        byte[] byArray4 = new byte[48];
        dataInputStream.read(byArray4, 0, 48);
        this.replyToQueueManagerName = this.makeStringFromBytes(byArray4, n, bl, true);
        byte[] byArray5 = new byte[12];
        dataInputStream.read(byArray5, 0, 12);
        this.userId = this.makeStringFromBytes(byArray5, n, bl, false);
        this.accountingToken = this.setArrayToLength(this.accountingToken, 32);
        dataInputStream.read(this.accountingToken, 0, 32);
        byte[] byArray6 = new byte[32];
        dataInputStream.read(byArray6, 0, 32);
        this.applicationIdData = this.makeStringFromBytes(byArray6, n, bl, false);
        this.putApplicationType = dataInputStream.readInt();
        byte[] byArray7 = new byte[28];
        dataInputStream.read(byArray7, 0, 28);
        this.putApplicationName = this.makeStringFromBytes(byArray7, n, bl, false);
        byte[] byArray8 = new byte[8];
        dataInputStream.read(byArray8, 0, 8);
        this.putDate = this.makeStringFromBytes(byArray8, n, bl, true);
        byte[] byArray9 = new byte[8];
        dataInputStream.read(byArray9, 0, 8);
        this.putTime = this.makeStringFromBytes(byArray9, n, bl, true);
        byte[] byArray10 = new byte[4];
        dataInputStream.read(byArray10, 0, 4);
        this.applicationOriginData = this.makeStringFromBytes(byArray10, n, bl, false);
        this.putDateTime = this.getDateAndTime(this.putDate, this.putTime);
        if (this.version > 1) {
            this.groupId = this.setArrayToLength(this.groupId, 24);
            dataInputStream.read(this.groupId, 0, 24);
            this.messageSequenceNumber = dataInputStream.readInt();
            this.offset = dataInputStream.readInt();
            this.messageFlags = dataInputStream.readInt();
            this.originalLength = dataInputStream.readInt();
        } else {
            this.groupId = MQC.MQGI_NONE;
            this.messageSequenceNumber = 1;
            this.offset = 0;
            this.messageFlags = 0;
            this.originalLength = -1;
        }
        Trace.exit(this, "readFrom");
        return dataInputStream;
    }

    protected final int sizeOfMQMD() {
        if (this.version == 1) {
            return 324;
        }
        return 364;
    }

    protected final byte[] setArrayToLength(byte[] byArray, int n) throws MQException {
        byte[] byArray2;
        try {
            byArray2 = new byte[n];
            if (byArray == null || byArray.length == 0) {
                int n2 = 0;
                while (n2 < n) {
                    byArray2[n2] = 0;
                    ++n2;
                }
            } else if (byArray.length < n) {
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                int n3 = byArray.length;
                while (n3 < n) {
                    byArray2[n3] = 0;
                    ++n3;
                }
            } else {
                System.arraycopy(byArray, 0, byArray2, 0, n);
            }
        }
        catch (Exception exception) {
            throw new MQInternalException(2, 2195, 85);
        }
        return byArray2;
    }

    protected final GregorianCalendar getDateAndTime(String string, String string2) {
        GregorianCalendar gregorianCalendar;
        if (Trace.isOn()) {
            Trace.entry(this, "getDateAndTime");
            Trace.trace(2, this, "Date = " + string + " Time = " + string2);
        }
        try {
            int n = Integer.parseInt(string.substring(0, 4));
            int n2 = Integer.parseInt(string.substring(4, 6));
            int n3 = Integer.parseInt(string.substring(6, 8));
            int n4 = Integer.parseInt(string2.substring(0, 2));
            int n5 = Integer.parseInt(string2.substring(2, 4));
            int n6 = Integer.parseInt(string2.substring(4, 6));
            int n7 = Integer.parseInt(string2.substring(6, 8)) * 10;
            gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6);
            ((Calendar)gregorianCalendar).setTimeZone(GMT);
            gregorianCalendar.set(14, n7);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            Trace.trace(1, this, "String index error" + stringIndexOutOfBoundsException);
            gregorianCalendar = new GregorianCalendar();
        }
        catch (NumberFormatException numberFormatException) {
            Trace.trace(1, this, "Number format exception" + numberFormatException);
            gregorianCalendar = new GregorianCalendar();
        }
        Trace.exit(this, "getDateAndTime");
        return gregorianCalendar;
    }

    static final String getDate(GregorianCalendar gregorianCalendar) {
        String string = gregorianCalendar != null ? MQMD.setNumberToLength(new Integer(gregorianCalendar.get(1)).toString(), 4) + MQMD.setNumberToLength(new Integer(gregorianCalendar.get(2) + 1).toString(), 2) + MQMD.setNumberToLength(new Integer(gregorianCalendar.get(5)).toString(), 2) : "        ";
        return string;
    }

    static final String getTime(GregorianCalendar gregorianCalendar) {
        String string = gregorianCalendar != null ? MQMD.setNumberToLength(new Integer(gregorianCalendar.get(11)).toString(), 2) + MQMD.setNumberToLength(new Integer(gregorianCalendar.get(12)).toString(), 2) + MQMD.setNumberToLength(new Integer(gregorianCalendar.get(13)).toString(), 2) + MQMD.setNumberToLength(new Integer(gregorianCalendar.get(14) / 10).toString(), 2) : "        ";
        return string;
    }

    private static final String setNumberToLength(String string, int n) {
        String string2;
        int n2 = string.length();
        if (n2 > n) {
            string2 = string.substring(0, n);
        } else {
            string2 = new String(string);
            int n3 = n2;
            while (n3 < n) {
                string2 = "0" + string2;
                ++n3;
            }
        }
        return string2;
    }

    protected final void setDateAndTime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (Trace.isOn()) {
            Trace.entry(this, "setDateAndTime");
            Trace.trace(2, this, "Year = " + n + " Month = " + n2 + " Day = " + n3);
            Trace.trace(2, this, "Time " + n4 + ":" + n5 + ":" + n6);
            Trace.trace(2, this, "Milliseconds = " + n7);
        }
        if (this.putDateTime == null) {
            this.putDateTime = new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6);
        } else {
            this.putDateTime.set(n, n2 - 1, n3, n4, n5, n6);
        }
        ((Calendar)this.putDateTime).setTimeZone(GMT);
        this.putDateTime.set(14, n7);
        if (Trace.isOn()) {
            Trace.exit(this, "setDateAndTime");
        }
    }
}

