/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQException;
import com.ibm.mq.MQJDConnectionRequestInfo;
import com.ibm.mq.MQManagedConnection;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mqservices.Trace;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

class MQJDManagedConnectionFactoryJ11
implements MQManagedConnectionFactory {
    private static final String sccsid = "common/javabase/com/ibm/mq/MQJDManagedConnectionFactoryJ11.java, java, j521  02/01/25 14:54:48 @(#) 1.11.1.1";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 2001    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String fieldQMGR = "";
    PrintWriter logWriter = null;

    MQJDManagedConnectionFactoryJ11(String string, Hashtable hashtable) {
        Trace.entry(this, "MQJDManagedConnectionFactoryJ11 constructor");
        this.setQMGR(string);
        Trace.exit(this, "MQJDManagedConnectionFactoryJ11 constructor");
    }

    public void setQMGR(String string) {
        this.fieldQMGR = string;
    }

    public String getQMGR() {
        return this.fieldQMGR;
    }

    public Object createConnectionFactory(MQConnectionManager mQConnectionManager) throws ResourceException {
        Trace.entry(this, "createConnectionFactory");
        Trace.exit(this, "createConnectionFactory (via exception)");
        throw new NotSupportedException("createConnectionFactory not supported by MQSeries");
    }

    public Object createConnectionFactory() throws ResourceException {
        Trace.entry(this, "createConnectionFactory");
        Trace.exit(this, "createConnectionFactory (via exception)");
        throw new NotSupportedException("createConnectionFactory not supported by MQSeries");
    }

    MQManagedConnectionJ11 _createManagedConnection(ConnectionRequestInfo connectionRequestInfo, boolean bl) throws ResourceException {
        MQManagedConnectionJ11 mQManagedConnectionJ11;
        Trace.entry(this, "_createManagedConnection");
        if (!(connectionRequestInfo instanceof MQJDConnectionRequestInfo)) {
            Trace.exit(this, "_createManagedConnection (via exception)");
            String string = MQException.getNLSMsg(105);
            throw new ResourceException(string);
        }
        MQJDConnectionRequestInfo mQJDConnectionRequestInfo = (MQJDConnectionRequestInfo)connectionRequestInfo;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("transport", "MQJD");
        if (mQJDConnectionRequestInfo.spi != null) {
            hashtable.put("SPI", mQJDConnectionRequestInfo.spi);
        }
        try {
            mQManagedConnectionJ11 = bl ? new MQManagedConnectionJ11(this.fieldQMGR, hashtable, connectionRequestInfo, this) : new MQManagedConnection(this.fieldQMGR, hashtable, connectionRequestInfo, this);
            mQManagedConnectionJ11.setLogWriter(this.logWriter);
        }
        catch (MQException mQException) {
            ResourceException resourceException = mQException.getResourceException();
            Trace.exit(this, "_createManagedConnection (via exception)");
            throw resourceException;
        }
        Trace.exit(this, "_createManagedConnection");
        return mQManagedConnectionJ11;
    }

    public MQManagedConnectionJ11 createManagedConnection(ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        return this._createManagedConnection(connectionRequestInfo, true);
    }

    public MQManagedConnectionJ11 matchManagedConnections(Vector vector, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Trace.entry(this, "matchManagedConnections");
        MQManagedConnectionJ11 mQManagedConnectionJ11 = null;
        if (!(connectionRequestInfo instanceof MQJDConnectionRequestInfo)) {
            String string = MQException.getNLSMsg(105);
            throw new ResourceException(string);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements() && mQManagedConnectionJ11 == null) {
            try {
                MQManagedConnectionJ11 mQManagedConnectionJ112 = (MQManagedConnectionJ11)enumeration.nextElement();
                if (!mQManagedConnectionJ112.isSuitable(connectionRequestInfo, this)) continue;
                mQManagedConnectionJ11 = mQManagedConnectionJ112;
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (Trace.isOn()) {
            if (mQManagedConnectionJ11 == null) {
                Trace.trace(2, this, "No suitable MQManagedConnection found");
            } else {
                Trace.trace(2, this, "Suitable MQManagedConnection found: " + mQManagedConnectionJ11);
            }
        }
        Trace.exit(this, "matchManagedConnections");
        return mQManagedConnectionJ11;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        MQJDManagedConnectionFactoryJ11 mQJDManagedConnectionFactoryJ11 = (MQJDManagedConnectionFactoryJ11)object;
        return MQJDManagedConnectionFactoryJ11.twoStringsEqual(this.fieldQMGR, mQJDManagedConnectionFactoryJ11.fieldQMGR);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalAccessError();
        }
    }

    static boolean twoStringsEqual(String string, String string2) {
        boolean bl = string == null && string2 == null ? true : (string == null || string2 == null ? false : string.equals(string2));
        return bl;
    }
}

