/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MQGetMessageOptions {
    private static final String sccsid = "@(#) common/javabase/com/ibm/mq/MQGetMessageOptions.java, java, j521, j521-L020126  02/01/25 15:49:31";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 5694-137 (c) Copyright IBM Corp. 1997, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final byte[] gmo_bytes = new byte[80];
    private boolean noReadBack = false;
    public int options = 0;
    public int waitInterval = 0;
    public String resolvedQueueName = "";
    public int matchOptions = 3;
    public char groupStatus = (char)32;
    public char segmentStatus = (char)32;
    public char segmentation = (char)32;
    protected static final int sizeofMQGetMessageOptionsv1 = 72;
    protected static final int sizeofMQGetMessageOptionsv2 = 80;
    private int version = 2;

    public MQGetMessageOptions() {
        Trace.entry(this, "MQGetMessageOptions constructor");
        Trace.trace(2, this, sccsid);
        this.gmo_bytes[0] = 71;
        this.gmo_bytes[1] = 77;
        this.gmo_bytes[2] = 79;
        this.gmo_bytes[3] = 32;
        this.gmo_bytes[7] = 2;
        Trace.exit(this, "MQGetMessageOptions constructor");
    }

    public MQGetMessageOptions(boolean bl) {
        this();
        if (bl) {
            Trace.trace(2, this, "Setting MQGMO noReadBack option");
            this.noReadBack = true;
        }
    }

    protected final int sizeOfMQGetMessageOptions() {
        if (this.version == 1) {
            return 72;
        }
        return 80;
    }

    protected final int getVersion() {
        return this.version;
    }

    protected final void setVersion(int n) throws MQException {
        Trace.entry(this, "setVersion");
        Trace.trace(2, this, "version = " + n);
        if (n > 2 || n < 1) {
            Trace.exit(this, "setVersion (via exception)");
            throw new MQInternalException(2, 2186, 82, "" + n);
        }
        this.version = n;
        this.gmo_bytes[7] = (byte)n;
        if (n == 1 && (this.matchOptions != 3 || this.groupStatus != ' ' || this.segmentStatus != ' ' || this.segmentation != ' ')) {
            Trace.exit(this, "setVersion (via exception)");
            throw new MQInternalException(2, 2186, 97);
        }
        Trace.exit(this, "setVersion");
    }

    protected final byte[] getV2Bytes() {
        this.gmo_bytes[8] = (byte)(this.options >>> 24 & 0xFF);
        this.gmo_bytes[9] = (byte)(this.options >>> 16 & 0xFF);
        this.gmo_bytes[10] = (byte)(this.options >>> 8 & 0xFF);
        this.gmo_bytes[11] = (byte)(this.options >>> 0 & 0xFF);
        this.gmo_bytes[12] = (byte)(this.waitInterval >>> 24 & 0xFF);
        this.gmo_bytes[13] = (byte)(this.waitInterval >>> 16 & 0xFF);
        this.gmo_bytes[14] = (byte)(this.waitInterval >>> 8 & 0xFF);
        this.gmo_bytes[15] = (byte)(this.waitInterval >>> 0 & 0xFF);
        if (this.version > 1) {
            this.gmo_bytes[72] = (byte)(this.matchOptions >>> 24 & 0xFF);
            this.gmo_bytes[73] = (byte)(this.matchOptions >>> 16 & 0xFF);
            this.gmo_bytes[74] = (byte)(this.matchOptions >>> 8 & 0xFF);
            this.gmo_bytes[75] = (byte)(this.matchOptions >>> 0 & 0xFF);
            this.gmo_bytes[76] = (byte)(this.groupStatus >>> 0 & 0xFF);
            this.gmo_bytes[77] = (byte)(this.segmentStatus >>> 0 & 0xFF);
            this.gmo_bytes[78] = (byte)(this.segmentation >>> 0 & 0xFF);
        }
        return this.gmo_bytes;
    }

    public final DataOutputStream writeTo(DataOutputStream dataOutputStream) throws IOException, MQException {
        Trace.entry(this, "writeTo");
        if (this.version > 1) {
            dataOutputStream.write(this.getV2Bytes(), 0, 80);
        } else {
            if (this.matchOptions != 3 || this.groupStatus != ' ' || this.segmentStatus != ' ' || this.segmentation != ' ') {
                Trace.exit(this, "writeTo (via exception)");
                throw new MQInternalException(2, 2186, 97);
            }
            dataOutputStream.write(this.getV2Bytes(), 0, 72);
        }
        Trace.exit(this, "writeTo");
        return dataOutputStream;
    }

    public final DataInputStream readFrom(DataInputStream dataInputStream) throws IOException, MQException {
        Trace.entry(this, "readFrom");
        if (dataInputStream.available() < 72) {
            Trace.exit(this, "readFrom (via exception)");
            throw new MQInternalException(2, 2195, 14);
        }
        if (this.noReadBack) {
            if (this.version == 1) {
                dataInputStream.skipBytes(72);
            } else {
                dataInputStream.skipBytes(80);
            }
            Trace.exit(this, "readFrom - optimised return");
            return dataInputStream;
        }
        dataInputStream.skipBytes(8);
        this.options = dataInputStream.readInt();
        this.waitInterval = dataInputStream.readInt();
        dataInputStream.skipBytes(8);
        byte[] byArray = new byte[48];
        dataInputStream.read(byArray, 0, 48);
        this.resolvedQueueName = MQEnvironment.stringFromBytes(byArray);
        if (this.version > 1) {
            this.matchOptions = dataInputStream.readInt();
            this.groupStatus = (char)dataInputStream.readByte();
            this.segmentStatus = (char)dataInputStream.readByte();
            this.segmentation = (char)dataInputStream.readByte();
            dataInputStream.skipBytes(1);
        } else {
            this.matchOptions = 3;
            this.groupStatus = (char)32;
            this.segmentStatus = (char)32;
            this.segmentation = (char)32;
        }
        Trace.exit(this, "readFrom");
        return dataInputStream;
    }
}

